/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.ui.internal.sharing;

import com.aptana.git.core.GitPlugin;
import com.aptana.git.core.model.IGitRepositoryManager;
import com.aptana.git.ui.internal.sharing.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class ConnectProviderOperation
implements IWorkspaceRunnable {
    private final IProject[] projects;

    public ConnectProviderOperation(IProject proj) {
        this(new IProject[]{proj});
    }

    protected ConnectProviderOperation(IProject[] projects) {
        this.projects = projects;
    }

    public void run(IProgressMonitor m) throws CoreException {
        if (m == null) {
            m = new NullProgressMonitor();
        }
        m.beginTask(Messages.ConnectProviderOperation_ConnectingProviderJob_Title, 100 * this.projects.length);
        try {
            IProject[] iProjectArray = this.projects;
            int n = this.projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                m.setTaskName(NLS.bind((String)Messages.ConnectProviderOperation_ConnectingProjectJob_Title, (Object)project.getName()));
                this.getGitRepositoryManager().attachExisting(project, (IProgressMonitor)new SubProgressMonitor(m, 100));
                ++n2;
            }
        }
        finally {
            m.done();
        }
    }

    private IGitRepositoryManager getGitRepositoryManager() {
        return GitPlugin.getDefault().getGitRepositoryManager();
    }
}

